<!-- resources/views/email_campaign/form.blade.php -->

<div class="container">
    <h2>Envoyer une campagne</h2>

    @if(session('error')) <div class="alert alert-danger">{{ session('error') }}</div> @endif

    <form action="{{ route('email_campaign.upload') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="form-group">
            <label>Choisir le template</label>
            <select name="template_id" class="form-control" required>
                <option value="">-- sélectionner --</option>
                @foreach($templates as $t)
                    <option value="{{ $t->id }}">{{ $t->name }}</option>
                @endforeach
            </select>
        </div>

        <div class="form-group mt-2">
            <label>CSV (name,phone,email)</label>
            <input type="file" name="csv_file" class="form-control" accept=".csv" required>
        </div>

        <button class="btn btn-primary mt-3">Uploader & Aperçu</button>
    </form>
</div>
