<!-- resources/views/email_campaign/form.blade.php -->

<div class="container">
    <h2>Envoyer une campagne</h2>

    <?php if(session('error')): ?> <div class="alert alert-danger"><?php echo e(session('error')); ?></div> <?php endif; ?>

    <form action="<?php echo e(route('email_campaign.upload')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="form-group">
            <label>Choisir le template</label>
            <select name="template_id" class="form-control" required>
                <option value="">-- sélectionner --</option>
                <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($t->id); ?>"><?php echo e($t->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="form-group mt-2">
            <label>CSV (name,phone,email)</label>
            <input type="file" name="csv_file" class="form-control" accept=".csv" required>
        </div>

        <button class="btn btn-primary mt-3">Uploader & Aperçu</button>
    </form>
</div>
<?php /**PATH C:\Users\pc\sendy_final\resources\views/pages/form.blade.php ENDPATH**/ ?>